%This program runs the simulations behind Fig. 10.

%We run 1,000 experiments of 1.10^6 episodes, with 2 AMMs, Delta_v = 4
%and \sigma = 5. After 10^6 episodes, Delta v changes to a different value Deltav2 for
%Ts = 1000 episodes, and changes back to the initial value for another 10^6 episodes. 
%We repeat the experiment for different values of Deltav.


%We record the average outcome in each episode.

clear

% record running time
% when producing the data the running time was 113 minutes.

tic

%Set the parameters:
K=1000;                 %K      is the number of experiments.
T1=1000000;             %T1      is the number of episodes before the shock.
alpha=0.01;             %alpha  is the learning rate.
beta=0.00008;           %beta   is the exploration decay rate.  
N = 2;                  %N is the number of AMMs.

%Set the value of the asset in the high/low state
vl=0;                   %value of the asset in low state
vh=4;                   %value of the asset in high state

%Set the value of the parameters of the normal distribution of L
mu_l=0;
sigma_l = 5;

%Set the price grid: middle of the grid, tick size, number of prices on
%each side of the middle. Hence, there are 2*grid_size+1 prices between
%grid_middle - tick*grid_size and grid_middle+tick*grid_size.

grid_middle = 8;
grid_size= 69;  
tick= 0.1;      

Ts = 1000;                %Ts is the length of the shock.
T2 = 10^6-Ts;             %T2 is the after shock period

% set random seed to ensure replicability
rng(1)

% Parallel computing initialization
delete(gcp("nocreate"));  % to close any existing pools that might be already running
myCluster = parcluster('local'); % get number of possible pools
parpool('local',8);

%Shock: Higher value of Delta v (Panels A and B)

Deltav2 = 7;
%Call the function simulation_rep to run K experiments, with Deltav2 = 7.
[av_all_episodes]=simulation_rep(alpha,beta,T1,Ts,T2,Deltav2,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,N,K);
%Save the output in the subfolder "Data"
writematrix(av_all_episodes,'Data/av_all_episodes_Deltav_7_Ts_1000.txt');

toc

%Shock: Placebo (Panel C)
Deltav2 = 4;
%Call the function simulation_rep to run K experiments, with Deltav2 = 4.
[av_all_episodes]=simulation_rep(alpha,beta,T1,Ts,T2,Deltav2,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,N,K);
%Save the output in the subfolder "Data"
writematrix(av_all_episodes,'Data/av_all_episodes_Placebo.txt');

toc

%Shock: Lower value of Delta v (Panel D)
Deltav2 = 1;
%Call the function simulation_rep to run K experiments, with Deltav2 = 1.
[av_all_episodes]=simulation_rep(alpha,beta,T1,Ts,T2,Deltav2,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,N,K);
%Save the output in the subfolder "Data"
writematrix(av_all_episodes,'Data/av_all_episodes_Deltav_1_Ts_1000.txt');

toc

